/**************************************************************************** *
 * FILE :
 *  Thermal_system_full_dsrtmdlfcn.c
 *
 *
 *
 * Copyright 2017, dSPACE GmbH. All rights reserved
 *
   \****************************************************************************/

#ifndef TEMP_DSRT_RTI
#include <rtmodel.h>
#include "rtwtypes.h"
#include "Thermal_system_full_dsrtmdlfcn.h"
#include <stdio.h>

int32_T DSRTStopSimulation = 0;
EXTERN_C_DECL void Thermal_system_full_initialize();
EXTERN_C_DECL void Thermal_system_full_terminate();

/* Initialization of model */
void Thermal_system_full_DSRTInitMdl(void)
{
  /* Initialize model */
  Thermal_system_full_initialize();

  /* Check for initialization errors */
  Thermal_system_full_DSRTCheckForErrorStatus();

  /* Reinit Stop Simulation flag*/
  DSRTStopSimulation = 0;
}

/* Model start function */
void Thermal_system_full_DSRTStartMdl(void)
{
  uint8_T lastApplStateStopped;
  Thermal_system_full_APLastApplStateStopped(&lastApplStateStopped);
  if (lastApplStateStopped) {
    /* Reinit main simulation structure */
    Thermal_system_full_DSRTInitMdl();
  }
}

/* Model stop function */
void Thermal_system_full_DSRTStopMdl(void)
{
  /* Call terminate function */
  Thermal_system_full_terminate();

  /* Check for model error status */
  Thermal_system_full_DSRTCheckForErrorStatus();
}

/* Check for model error status */
void Thermal_system_full_DSRTCheckForErrorStatus()
{
  const char_T* errorStatus = rtmGetErrorStatus(Thermal_system_full_M);
  if (errorStatus != NULL && strcmp(errorStatus, "Simulation finished") == 0) {
    /* The RTM errorStatus field has been set */
    Thermal_system_full_APTerminateSimulation();
    Thermal_system_full_APPrintMessage(
      "Model 'Thermal_system_full' error status:");
    Thermal_system_full_APPrintMessage(errorStatus);
  }
}

/* Check for simulation stop conditions */
void Thermal_system_full_DSRTCheckForSimulationStopCondition(void)
{
  const char_T* errorStatus = rtmGetErrorStatus(Thermal_system_full_M);
  double stopTime = 1369.0;
  if (stopTime > 0.0 && Thermal_system_full_M->Timing.t[0] > stopTime) {
    if (DSRTStopSimulation != 1) {
      /* The simulation stop time has been reached */
      Thermal_system_full_APStopSimulation();
      Thermal_system_full_APPrintMessage(
        "Model 'Thermal_system_full': Reached the model simulation stop time 1369.0.");
      DSRTStopSimulation = 1;
    }
  } else if (errorStatus != NULL) {
    if (DSRTStopSimulation != 1) {
      /* The RTM errorStatus field was set */
      Thermal_system_full_APTerminateSimulation();
      Thermal_system_full_APPrintMessage(
        "Model 'Thermal_system_full' error status:");
      Thermal_system_full_APPrintMessage(errorStatus);
      DSRTStopSimulation = 1;
    }
  } else if (rtmGetStopRequested(Thermal_system_full_M)) {
    if (DSRTStopSimulation != 1) {
      Thermal_system_full_APStopSimulation();
      Thermal_system_full_APPrintMessage(
        "Model 'Thermal_system_full': Executed a Simulink Stop Simulation block or request.");
      DSRTStopSimulation = 1;
    }
  }
}

#endif
